//
//  CRMaterialSphereEditor.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/19/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRMaterialSphere;

//////////////////////////////////////////////////////////////////////
// Sphere spot point
//////////////////////////////////////////////////////////////////////
@interface CRSphereSpotPoint : NSObject
{
	id __unsafe_unretained delegate;
}

@property (copy)   NSColor* color;
@property (assign) NSPoint	location;
@property (assign) CGFloat	glossiness;
@property (assign) CGFloat	height;

- (id)initWithDelegate:(id)aDelegate;
- (id)initWithFilter:(CIFilter *)filter delegate:(id)aDelegate;
+ (id)pointWithFilter:(CIFilter *)filter delegate:(id)aDelegate;

- (CIFilter *)filter;

@end

//////////////////////////////////////////////////////////////////////
// Sphere material editor
//////////////////////////////////////////////////////////////////////
@interface CRMaterialSphereEditor : CRControl
{
	CRMaterialSphere*	material;
	NSMutableArray*		points;			// working array of points
	
	BOOL				ignoreHandler;
	CRSphereSpotPoint*	selectedPoint;	// selected point
	CRPointAction		action;			// current action
}

// properties
@property (strong)		CRMaterialSphere*	material;
@property (readonly)	CRSphereSpotPoint*	selectedPoint;
@property (copy)		NSColor*			defaultColor;

// outlets
@property (assign)		IBOutlet id			actionDelegate;

- (IBAction)moveSpotToFront:(id)sender;
- (IBAction)moveSpotToBack:(id)sender;
- (IBAction)moveSpotWithSegmentedControl:(id)sender;

@end